document.addEventListener("DOMContentLoaded", function () {
  // MENU RESPONSIVO
  const navLinks = document.querySelectorAll(".navbar-nav a");
  navLinks.forEach((link) => {
    link.addEventListener("click", function () {
      const navbarCollapse = document.querySelector(".navbar-collapse");
      if (navbarCollapse.classList.contains("in")) {
        navbarCollapse.classList.remove("in");
        navbarCollapse.style.height = "0px";
        document.querySelector(".navbar-toggle").classList.add("collapsed");
      }
    });
  });

  // FILTRO DO MENU DE COMIDA
  const filters = document.querySelectorAll(".food-menu-list-menu .filter");
  const menuItems = document.querySelectorAll(".single-menu");
  let isMobile = window.matchMedia("(max-width: 768px)").matches;
  let currentFilter = null;

  if (isMobile) {
    menuItems.forEach((item) => item.classList.add("hide"));
  }
  filters.forEach((filter) => {
    filter.addEventListener("click", function () {
      const filterValue = this.getAttribute("data-filter");
      currentFilter =
        currentFilter === filterValue
          ? (filters.forEach((el) => el.classList.remove("active")),
            menuItems.forEach((el) => el.classList.add("hide")),
            null)
          : (filters.forEach((el) => el.classList.remove("active")),
            this.classList.add("active"),
            menuItems.forEach((item) => {
              item.classList.contains(filterValue.substring(1))
                ? item.classList.remove("hide")
                : item.classList.add("hide");
            }),
            filterValue);
    });
  });

  // FILTRO DA GALERIA
  const galleryFilters = document.querySelectorAll(".gallery-area .filter");
  const galleryItems = document.querySelectorAll(".gallery-item");
  galleryItems.forEach((item) => item.classList.add("show"));
  galleryFilters.forEach((filter) => {
    filter.addEventListener("click", function () {
      galleryFilters.forEach((el) => el.classList.remove("active"));
      this.classList.add("active");
      const filterValue = this.getAttribute("data-filter");
      galleryItems.forEach((item) => {
        if (
          filterValue === "*" ||
          item.classList.contains(filterValue.substring(1))
        ) {
          item.classList.remove("hide");
          item.classList.add("show");
        } else {
          item.classList.remove("show");
          item.classList.add("hide");
        }
      });
    });
  });

  // CONFIGURAÇÃO DO VÍDEO DA HOME (lazy load)
  const homeVideo = document.querySelector("video.video-home.lazy-video");
  if (homeVideo) {
    homeVideo.muted = true;
    homeVideo.autoplay = true;
    homeVideo.playsInline = true;
    homeVideo.removeAttribute("controls");
    if ("IntersectionObserver" in window) {
      const observer = new IntersectionObserver((entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            const videoEl = entry.target;
            if (videoEl.dataset.src) {
              videoEl.src = videoEl.dataset.src;
              videoEl.load();
              videoEl.play();
            }
            observer.unobserve(videoEl);
          }
        });
      });
      observer.observe(homeVideo);
    } else if (homeVideo.dataset.src) {
      homeVideo.src = homeVideo.dataset.src;
      homeVideo.load();
      homeVideo.play();
    }
    homeVideo.addEventListener("play", () => {
      homeVideo.removeAttribute("controls");
    });
  }

  // CONFIGURAÇÃO DOS VÍDEOS GIF (lazy load)
  const gifVideos = document.querySelectorAll("video.video-gif.lazy-video");
  if ("IntersectionObserver" in window) {
    const gifObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          const videoEl = entry.target;
          if (videoEl.dataset.src) {
            videoEl.src = videoEl.dataset.src;
            videoEl.load();
            videoEl.play();
          }
          gifObserver.unobserve(videoEl);
        }
      });
    });
    gifVideos.forEach((video) => gifObserver.observe(video));
  } else {
    gifVideos.forEach((video) => {
      if (video.dataset.src) {
        video.src = video.dataset.src;
        video.load();
        video.play();
      }
    });
  }

  // VALIDAÇÃO DO INPUT DO TELEFONE
  document.getElementById("mobile").addEventListener("input", function (e) {
    var target = e.target;
    var warning = document.getElementById("mobile-warning");
    target.value = target.value.replace(/[^+\d]/g, "");
    if (
      (target.value.match(/\+/g) || []).length > 1 ||
      target.value.indexOf("+") > 0
    ) {
      target.value = target.value.replace(/\+/g, "");
    }
    warning.style.display = /[^+\d]/.test(e.data) ? "block" : "none";
  });

  // SCROLL SUAVE PARA LINKS ÂNCORA
  document.querySelectorAll('a[href^="#"]').forEach((link) => {
    link.addEventListener("click", function (e) {
      e.preventDefault();
      document.querySelector(this.getAttribute("href")).scrollIntoView({
        behavior: "smooth",
        block: "start",
      });
    });
  });

  /*==============================
        FUNÇÕES DE TRADUÇÃO
    ==============================*/
  let languages = {};

  // Função para carregar JSON de um idioma
  function loadLanguage(lang) {
    return fetch(`translations/${lang}.json`)
      .then((response) => {
        if (!response.ok) {
          throw new Error(`Erro ao carregar ${lang}.json: ${response.status}`);
        }
        return response.json();
      })
      .catch((err) => {
        console.error(`Erro ao carregar ${lang}.json:`, err);
        return {}; // Define um idioma padrão vazio se falhar
      });
  }

  // Função para atualizar o texto na página, incluindo placeholders
  function updateLanguage(lang) {
    console.log(`Atualizando para o idioma: ${lang}`); // Depuração
    const elements = document.querySelectorAll("[data-i18n]");
    elements.forEach((element) => {
      const key = element.getAttribute("data-i18n");
      const keys = key.split(".");
      let value = languages[lang];
      for (let k of keys) {
        value = value ? value[k] : null;
      }
      if (value !== null && value !== undefined) {
        if (key.startsWith("[placeholder]")) {
          // Remove "[placeholder]" do key para pegar o valor correto do JSON
          const cleanKey = key.replace("[placeholder]", "").trim();
          const translation = languages[lang][cleanKey];
          if (
            element.tagName.toLowerCase() === "input" ||
            element.tagName.toLowerCase() === "select"
          ) {
            element.setAttribute("placeholder", translation || "");
          }
        } else if (element.classList.contains("cd-headline")) {
          // Para elementos animados, atualiza o conteúdo interno
          const wrapper =
            element.querySelector(".cd-words-wrapper b") ||
            element.querySelector("span");
          if (wrapper) {
            wrapper.innerHTML = value;
          } else {
            element.innerHTML = value;
          }
        } else if (element.querySelector("span, strong")) {
          // Preserva spans ou strong internos, mas atualiza apenas o texto principal para itens do menu
          const child = element.querySelector("span, strong");
          if (child && child.classList.contains("menu-price")) {
            // Para elementos do menu, mantém o <span class="menu-price"> e atualiza só o texto principal
            const textNode = element.childNodes[0]; // O texto antes do <span>
            if (textNode && textNode.nodeType === Node.TEXT_NODE) {
              textNode.textContent = value;
            }
          } else {
            child.innerHTML = value; // Para outros spans/strong, substitui o conteúdo
          }
        } else {
          element.innerHTML = value;
        }
      } else {
        console.warn(`Chave não encontrada no idioma ${lang}: ${key}`);
      }
    });

    // Mostrar/esconder o "R" inicial na seção About
    const bigR = document.getElementById("bigR");
    if (bigR) {
      bigR.style.display = lang === "pt" ? "inline" : "none";
    }

    // Atualiza a bandeira visível
    const currentFlag = document.getElementById("currentFlag");
    if (currentFlag) {
      currentFlag.src = `img/icon/${lang}.png`;
    }

    // Atualiza o atributo lang do HTML para acessibilidade
    document.documentElement.setAttribute("lang", lang);
  }

  // Função para atualizar o campo oculto do idioma no formulário
  function updateLanguageField(lang) {
    const languageInput = document.getElementById("languageInput");
    if (languageInput) {
      languageInput.value = lang; // Define o valor do campo oculto com o idioma atual
      console.log(`Campo oculto de idioma atualizado para: ${lang}`); // Depuração
    } else {
      console.warn(
        "Campo oculto 'languageInput' não encontrado no formulário."
      );
    }
  }

  // Carregar todos os idiomas ao iniciar
  Promise.all([
    loadLanguage("pt"),
    loadLanguage("en"),
    loadLanguage("fr"),
    loadLanguage("de"),
  ])
    .then(([pt, en, fr, de]) => {
      languages["pt"] = pt || {};
      languages["en"] = en || {};
      languages["fr"] = fr || {};
      languages["de"] = de || {};

      console.log("Idiomas carregados:", languages); // Depuração

      // Carregar idioma salvo ou usar "pt" como padrão
      const savedLanguage = localStorage.getItem("language") || "pt";
      updateLanguage(savedLanguage);
      updateLanguageField(savedLanguage); // Atualiza o campo oculto ao carregar a página

      // Eventos de clique no dropdown
      document
        .querySelectorAll(".language-dropdown .dropdown-menu a")
        .forEach((link) => {
          link.addEventListener("click", function (e) {
            e.preventDefault();
            const lang = this.getAttribute("data-lang");
            localStorage.setItem("language", lang); // Salvar idioma no localStorage
            console.log(`Mudando para o idioma: ${lang}`); // Depuração
            updateLanguage(lang);
            updateLanguageField(lang); // Atualiza o campo oculto do formulário ao mudar o idioma
          });
        });

      // Garantir que o campo oculto seja preenchido antes do envio do formulário
      const reservationForm = document.getElementById("reservationForm");
      if (reservationForm) {
        reservationForm.addEventListener("submit", function (e) {
          const lang = localStorage.getItem("language") || "pt";
          updateLanguageField(lang); // Garante que o idioma esteja no campo oculto
        });
      } else {
        console.warn("Formulário com ID 'reservationForm' não encontrado.");
      }
    })
    .catch((err) => console.error("Erro ao carregar idiomas:", err));
});
