<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Recuperar e sanitizar os dados do formulário
    $name = htmlspecialchars(trim($_POST["name"]));
    $email = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
    $mobile = htmlspecialchars(trim($_POST["phone"])); 
    $date = htmlspecialchars(trim($_POST["date"]));
    $time = htmlspecialchars(trim($_POST["time"]));
    $person = htmlspecialchars(trim($_POST["person"]));
    $language = strtolower(trim($_POST["language"])); // Normalizar para minúsculas

    // Validar o email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "O endereço de email não é válido.";
        exit;
    }

    // Prevenir ataques de spam (honeypot)
    if (!empty($_POST['honeypot'])) {
        echo "Detecção de spam. Reserva não enviada.";
        exit;
    }

    // Definir idiomas suportados
    $supportedLanguages = ['pt', 'en', 'fr','de']; // Adicione outros idiomas conforme necessário
    if (!in_array($language, $supportedLanguages)) {
        $language = 'pt'; // Idioma padrão se inválido
    }

    // Configuração do e-mail
    $to = "adragarestaurante@gmail.com";
    $subject = "Reserva de Mesa - form";
    $message = "Nome: $name\n";
    $message .= "Email: $email\n";
    $message .= "Telefone: $mobile\n";
    $message .= "Data: $date\n";
    $message .= "Hora: $time\n";
    $message .= "Número de pessoas: $person\n";

    // Cabeçalhos do e-mail
    $from_email = "cliente@diogopinto1.com";
    $headers = "From: $from_email\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Enviar o e-mail e verificar o sucesso
    if (mail($to, $subject, $message, $headers)) {
        // Redirecionar para a página de confirmação baseada no idioma
        $confirmationPage = "confirmacao_{$language}.html";
        header("Location: $confirmationPage");
        exit;
    } else {
        echo "Ocorreu um erro ao enviar o email. Por favor, tente novamente mais tarde.";
        exit;
    }
}
?>